/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSGenericConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class LandBasedEndStructure<C extends RSGenericConfig>
extends GenericJigsawStructure<C> {
    public LandBasedEndStructure(Codec<C> codec) {
        super(codec, LandBasedEndStructure::isLandFeatureChunk, LandBasedEndStructure::generateLandPieces);
    }

    protected static <CC extends RSGenericConfig> boolean isLandFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        int zBlockPos;
        int radius = 1000;
        int xBlockPos = context.f_197355_().m_45604_();
        if (xBlockPos * xBlockPos + (zBlockPos = context.f_197355_().m_45605_()) * zBlockPos <= radius * radius) {
            return false;
        }
        return GenericJigsawStructure.isGenericFeatureChunk(context) && LandBasedEndStructure.getTerrainHeight(context.f_197355_(), context.f_197352_(), context.f_197357_()) >= Math.min(GeneralUtils.getMaxTerrainLimit(context.f_197352_()), 50);
    }

    private static int getTerrainHeight(ChunkPos chunkPos1, ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView) {
        int xPos = chunkPos1.f_45578_ << 4;
        int zPos = chunkPos1.f_45579_ << 4;
        int height = chunkGenerator.m_156179_(xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        BlockPos pos = new BlockPos(xPos, GeneralUtils.getMaxTerrainLimit(chunkGenerator), zPos);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122190_((Vec3i)pos).m_122175_(direction, 16);
            height = Math.min(height, chunkGenerator.m_156179_(mutable.m_123341_(), mutable.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView));
        }
        return height;
    }

    public static <CC extends RSGenericConfig> Optional<PieceGenerator<CC>> generateLandPieces(PieceGeneratorSupplier.Context<CC> context) {
        RSGenericConfig config = (RSGenericConfig)context.f_197356_();
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), config.setFixedYSpawn, context.f_197355_().m_45605_());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), blockpos, !config.doNotUseHeightmap, !config.doNotUseHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            BoundingBox box = ((PoolElementStructurePiece)pieces.get(0)).m_73547_();
            BlockPos centerPos = new BlockPos((Vec3i)box.m_162394_());
            int radius = (int)Math.sqrt(box.m_71053_().m_123341_() * box.m_71053_().m_123341_() + box.m_71053_().m_123343_() * box.m_71053_().m_123343_()) / 2;
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = context.f_197352_().m_156179_(centerPos.m_123341_() + xOffset, centerPos.m_123343_() + zOffset, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    landHeights.add(landHeight);
                }
            }
            int avgHeight = (int)Math.max(landHeights.stream().mapToInt(Integer::intValue).average().orElse(0.0), 50.0);
            int parentHeight = ((PoolElementStructurePiece)pieces.get(0)).m_73547_().m_162396_();
            int offsetAmount = avgHeight - parentHeight + config.centerYOffset;
            pieces.forEach(child -> child.m_6324_(0, offsetAmount, 0));
        });
    }
}

